<button
    data-target="#{{ \Illuminate\Support\Str::slug($item->menu_title) }}"
    @class(['group/trigger text-start', 'lqd-is-active' => $loop->first])
>
    <span class="flex items-center gap-6 text-[24px] font-normal group-[&.lqd-is-active]/trigger:text-white md:text-[32px]">
        <span class="w-8 group-[&.lqd-is-active]/trigger:text-primary [&_svg]:h-auto [&_svg]:w-full">
            {{-- TODO: add trigger icon html option --}}
            @if ($item->icon)
                {!! $item->icon !!}
            @else
                <svg
                    width="32"
                    height="31"
                    viewBox="0 0 32 31"
                    fill="currentColor"
                    xmlns="http://www.w3.org/2000/svg"
                >
                    <path
                        d="M30.3333 12.9241C31.408 14.1428 32 15.7081 32 17.3334V24.0001C32 27.6761 29.0093 30.6668 25.3333 30.6668H6.66667C2.99067 30.6668 0 27.6761 0 24.0001V17.3334C0 13.6574 2.99067 10.6668 6.66667 10.6668H12C12.7373 10.6668 13.3333 11.2641 13.3333 12.0001C13.3333 12.7361 12.7373 13.3334 12 13.3334H6.66667C4.46133 13.3334 2.66667 15.1281 2.66667 17.3334V24.0001C2.66667 26.2054 4.46133 28.0001 6.66667 28.0001H25.3333C27.5387 28.0001 29.3333 26.2054 29.3333 24.0001V17.3334C29.3333 16.3588 28.9773 15.4188 28.3333 14.6881C27.8467 14.1361 27.8987 13.2934 28.452 12.8054C29.0027 12.3201 29.8453 12.3721 30.3333 12.9241ZM6.66667 20.6668C6.66667 21.7708 7.56267 22.6668 8.66667 22.6668C9.77067 22.6668 10.6667 21.7708 10.6667 20.6668C10.6667 19.5628 9.77067 18.6668 8.66667 18.6668C7.56267 18.6668 6.66667 19.5628 6.66667 20.6668ZM15.3333 22.6668C16.4373 22.6668 17.3333 21.7708 17.3333 20.6668C17.3333 19.5628 16.4373 18.6668 15.3333 18.6668C14.2293 18.6668 13.3333 19.5628 13.3333 20.6668C13.3333 21.7708 14.2293 22.6668 15.3333 22.6668ZM16 14.6668V12.5521C16 11.1281 16.5547 9.78811 17.5627 8.78144L25.172 1.17211C26.732 -0.387894 29.268 -0.387894 30.828 1.17211C31.5827 1.92677 32 2.93211 32 4.00011C32 5.06811 31.5827 6.07344 30.828 6.82944L23.2187 14.4388C22.212 15.4454 20.872 16.0014 19.448 16.0014H17.3333C16.596 16.0014 16 15.4041 16 14.6681V14.6668ZM18.6667 13.3334H19.448C20.16 13.3334 20.8293 13.0561 21.3333 12.5521L28.9427 4.94277C29.1947 4.69077 29.3333 4.35611 29.3333 4.00011C29.3333 3.64411 29.1947 3.30944 28.9427 3.05744C28.4213 2.53611 27.5787 2.53744 27.0573 3.05744L19.448 10.6668C18.952 11.1641 18.6667 11.8508 18.6667 12.5521V13.3334Z"
                    />
                </svg>
            @endif
        </span>
        {!! __(ucfirst($item->menu_title)) !!}
        @if (!empty($badge))
            <span class="ml-1 inline-block rounded-md bg-primary bg-opacity-10 p-[0.375rem] px-2 text-primary">{{ $badge }}</span>
        @endif
    </span>
    <span class="mt-7 hidden group-[&.lqd-is-active]/trigger:block lg:ps-14">
        {!! __($item->text) !!}
    </span>
    <img
        class="mt-10 hidden w-full max-lg:group-[&.lqd-is-active]/trigger:block"
        width="878"
        height="748"
        src="{{ custom_theme_url($item->image, true) }}"
        alt="{{ __($item->image_title) }}"
    >
</button>
